#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Falling Random NumbersMod01.fsh  by Dr2
//https://www.shadertoy.com/view/7stSWf
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.628318  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// "Falling Random Numbers" by dr2 - 2021
// License: Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License

// Use at your peril

// (Based on "Panspermia Incoming")

#define AA  1  // optional antialiasing

#if 0
#define VAR_ZERO min (iFrame, 0)
#else
#define VAR_ZERO 0
#endif

float PrRoundBoxDf (vec3 p, vec3 b, float r);
float PrRoundBox2Df (vec2 p, vec2 b, float r);
float Minv3 (vec3 p);
float Minv2 (vec2 p);
float Maxv2 (vec2 p);
vec2 Rot2D (vec2 q, float a);
mat3 StdVuMat (float el, float az);
float ShowIntPZ (vec2 q, vec2 cBox, float mxChar, float val);
float Hashfv2 (vec2 p);
float Hashfv3 (vec3 p);
vec3 Hashv3f (float p);
float Fbm1 (float p);
float Fbm2 (vec2 p);

vec3 qrHit, bGrid, cId, sunDir, obDisp, obRot;
float dstFar, tCur, vSpd, rNum;
bool cOcc;
const float pi = 3.1415927;

float ObjDf (vec3 p)
{
  float d;
  d = dstFar;
  if (cOcc) {
    p -= obDisp;
    p.yz = Rot2D (p.yz, obRot.x);
    p.xz = Rot2D (p.xz, obRot.y);
    p.xy = Rot2D (p.xy, obRot.z);
    d = PrRoundBoxDf (p, vec3 (0.5, 0.01, 0.3), 0.02);
    qrHit = p;
  }
  return d;
}

void ObjState ()
{
  vec3 vRan;
  vRan = Hashv3f (dot (cId, vec3 (31.1, 41.1, 51.1)) + 99.);
  cOcc = (vRan.x * step (2., length (cId.xz)) > 0.5);
  if (cOcc) {
    obDisp = bGrid * (cId + 0.5) + (0.2 + 0.1 * bGrid.x * vRan.x) *
       vec3 (sin (0.6 * vRan.z * tCur + vRan.x) * vec2 (0.5 * pi, 0.), 0.).xzy;
    obRot = (vRan - 0.5) * 0.5 * tCur;
    rNum = Hashfv3 (vec3 (31.1, 41.1, 51.1) * cId + 99.);
  }
}

vec3 ObjCell (vec3 p)
{
  cId.xz = floor (p.xz / bGrid.xz);
  p.y += vSpd * tCur * (1. + Hashfv2 (cId.xz));
  cId.y = floor (p.y / bGrid.y);
  return p;
}

float ObjRay (vec3 ro, vec3 rd)
{
  vec3 p, cIdP, rdi;
  float dHit, d, eps;
  eps = 0.0005;
  if (rd.x == 0.) rd.x = 0.001;
  if (rd.y == 0.) rd.y = 0.001;
  if (rd.z == 0.) rd.z = 0.001;
  rdi = 1. / rd;
  cIdP = vec3 (-999.);
  dHit = eps;
  for (int j = VAR_ZERO; j < 160; j ++) {
    p = ObjCell (ro + dHit * rd);
    if (cId != cIdP) {
      ObjState ();
      cIdP = cId;
    }
    d = ObjDf (p);
    d = min (d, abs (Minv3 ((bGrid * (cId + step (0., rd)) - p) * rdi)) + eps);
    dHit += d;
    if (d < eps || dHit > dstFar) break;
  }
  if (d >= eps) dHit = dstFar;
  return dHit;
}

vec3 ObjNf (vec3 p)
{
  vec4 v;
  vec2 e;
  e = vec2 (0.001, -0.001);
  for (int j = VAR_ZERO; j < 4; j ++) {
    v[j] = ObjDf (p + ((j < 2) ? ((j == 0) ? e.xxx : e.xyy) : ((j == 2) ? e.yxy : e.yyx)));
  }
  v.x = - v.x;
  return normalize (2. * v.yzw - dot (v, vec4 (1.)));
}

vec3 BgCol (vec3 ro, vec3 rd)
{
  vec3 col, clCol;
  vec2 q;
  float f, fd, ff;
  if (rd.y > -0.02 && rd.y < 0.03 * Fbm1 (16. * atan (rd.z, - rd.x))) {
    col = mix (vec3 (0.4, 0.5, 0.7), vec3 (0.3, 0.45, 0.55), smoothstep (-0.02, 0.01, rd.y));
  } else if (rd.y > 0.) {
    q = 0.005 * (ro.xz + tCur * vec2 (0.5, 2.) + ((200. - ro.y) / rd.y) * rd.xz);
    ff = Fbm2 (q);
    f = smoothstep (0.1, 0.8, ff);
    fd = smoothstep (0.1, 0.8, Fbm2 (q + 0.01 * sunDir.xz)) - f;
    clCol = (0.8 + 0.5 * ff) * (vec3 (0.7) - 0.7 * vec3 (0.3, 0.3, 0.2) * sign (fd) *
       smoothstep (0., 0.05, abs (fd)));
    fd = smoothstep (0.01, 0.1, rd.y);
    col = mix (mix (vec3 (0.8, 0.8, 0.75), vec3 (0.4, 0.5, 0.8), 0.3 + 0.7 * fd), clCol,
       0.1 + 0.9 * f * fd);
  } else {
    col = vec3 (0.1, 0.5, 0.1);
  }
  return col;
}

vec3 ShowScene (vec3 ro, vec3 rd)
{
  vec3 col, bgCol, vn, p;
  float dstObj;
  bGrid = vec3 (4.);
  vSpd = 0.2;
  bgCol = BgCol (ro, rd);
  col = bgCol;
  dstObj = ObjRay (ro, rd);
  if (dstObj < dstFar) {
    ro += dstObj * rd;
    p = ObjCell (ro);
    ObjState ();
    vn = ObjNf (p);
    col = mix (vec3 (1., 1., 0.8), vec3 (0., 0., 1.), ShowIntPZ (vec2 (qrHit.x * sign (qrHit.y),
       qrHit.z) - vec2 (0.3, -0.18), vec2 (0.6, 0.4), 5., 1. + floor ((1e5 - 1.) * rNum)));
    col = mix (vec3 (0., 0., 1.), col, smoothstep (0., 0.02, PrRoundBox2Df (qrHit.xz -
       vec2 (0., -0.25), vec2 (0.4, 0.005), 0.005)));
    col *= 0.4 + 0.6 * max (dot (vn, sunDir), 0.);
    col = mix (col, bgCol, smoothstep (0.5, 0.95, dstObj / dstFar));
  }
  return clamp (col, 0., 1.);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
  mat3 vuMat;
  vec4 mPtr;
  vec3 ro, rd, col;
  vec2 canvas, uv;
  float el, az, sr, zmFac;
  canvas = iResolution.xy;
  uv = 2. * fragCoord.xy / canvas - 1.;
  uv.x *= canvas.x / canvas.y;
  tCur = iTime;
  mPtr = iMouse;
  mPtr.xy = mPtr.xy / canvas - 0.5;
  az = 0.;
  el = 0.085 * pi;
  if (mPtr.z > 0.) {
    az += 2. * pi * mPtr.x;
    el += 0.5 * pi * mPtr.y;
  }
  el = clamp (el, 0.085 * pi, 0.4 * pi);
  vuMat = StdVuMat (el, az);
  ro = vec3 (0.5);
  zmFac = 3.5;
  dstFar = 40.;
  sunDir = normalize (vec3 (1., 2., -1.));
#if ! AA
  const float naa = 1.;
#else
  const float naa = 3.;
#endif  
  col = vec3 (0.);
  sr = 2. * mod (dot (mod (floor (0.5 * (uv + 1.) * canvas), 2.), vec2 (1.)), 2.) - 1.;
  for (float a = float (VAR_ZERO); a < naa; a ++) {
    rd = vuMat * normalize (vec3 (uv + step (1.5, naa) * Rot2D (vec2 (0.5 / canvas.y, 0.),
       sr * (0.667 * a + 0.5) * pi), zmFac));
    col += (1. / naa) * ShowScene (ro, rd);
  }
  fragColor = vec4 (col, 1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

float PrRoundBoxDf (vec3 p, vec3 b, float r)
{
  return length (max (abs (p) - b, 0.)) - r;
}

float PrRoundBox2Df (vec2 p, vec2 b, float r)
{
  return length (max (abs (p) - b, 0.)) - r;
}

float Minv3 (vec3 p)
{
  return min (p.x, min (p.y, p.z));
}

float Minv2 (vec2 p)
{
  return min (p.x, p.y);
}

float Maxv2 (vec2 p)
{
  return max (p.x, p.y);
}

mat3 StdVuMat (float el, float az)
{
  vec2 ori, ca, sa;
  ori = vec2 (el, az);
  ca = cos (ori);
  sa = sin (ori);
  return mat3 (ca.y, 0., - sa.y, 0., 1., 0., sa.y, 0., ca.y) *
         mat3 (1., 0., 0., 0., ca.x, - sa.x, 0., sa.x, ca.x);
}

vec2 Rot2D (vec2 q, float a)
{
  vec2 cs;
  cs = sin (a + vec2 (0.5 * pi, 0.));
  return vec2 (dot (q, vec2 (cs.x, - cs.y)), dot (q.yx, cs));
}

float DigSeg (vec2 q)
{
  q = 1. - smoothstep (vec2 (0.), vec2 (0.04, 0.07), abs (q) - vec2 (0.13, 0.5));
  return q.x * q.y;
}

#define DSG(q) k = kk;  kk = k / 2;  if (kk * 2 != k) d += DigSeg (q)

float ShowDig (vec2 q, int iv)
{
  vec2 vp, vm, vo;
  float d;
  int k, kk;
  vp = vec2 (0.5, 0.5);
  vm = vec2 (-0.5, 0.5);
  vo = vp - vm;
  if (iv == -1) k = 8;
  else if (iv < 2) k = (iv == 0) ? 119 : 36;
  else if (iv < 4) k = (iv == 2) ? 93 : 109;
  else if (iv < 6) k = (iv == 4) ? 46 : 107;
  else if (iv < 8) k = (iv == 6) ? 122 : 37;
  else             k = (iv == 8) ? 127 : 47;
  q = (q - 0.5) * vec2 (1.8, 2.3);
  d = 0.;
  kk = k;
  DSG (q.yx - vo);  DSG (q.xy - vp);  DSG (q.xy - vm);  DSG (q.yx);
  DSG (q.xy + vm);  DSG (q.xy + vp);  DSG (q.yx + vo);
  return d;
}

float ShowIntPZ (vec2 q, vec2 cBox, float mxChar, float val)
{
  float nDig, idChar, s, v;
  q = vec2 (- q.x, q.y) / cBox;
  s = 0.;
  if (Minv2 (q) >= 0. && Maxv2 (q) < 1.) {
    q.x *= mxChar;
    nDig = mxChar;
    idChar = mxChar - 1. - floor (q.x);
    q.x = fract (q.x);
    v = max (val, 0.) / pow (10., mxChar - idChar - 1.);
    if (idChar >= mxChar - nDig) s = ShowDig (q, int (mod (floor (v), 10.)));
  }
  return s;
}

const float cHashM = 43758.54;

float Hashfv2 (vec2 p)
{
  return fract (sin (dot (p, vec2 (37., 39.))) * cHashM);
}

float Hashfv3 (vec3 p)
{
  return fract (sin (dot (p, vec3 (37., 39., 41.))) * cHashM);
}

vec2 Hashv2f (float p)
{
  return fract (sin (p + vec2 (0., 1.)) * cHashM);
}

vec2 Hashv2v2 (vec2 p)
{
  vec2 cHashVA2 = vec2 (37., 39.);
  return fract (sin (dot (p, cHashVA2) + vec2 (0., cHashVA2.x)) * cHashM);
}

vec3 Hashv3f (float p)
{
  return fract (sin (p + vec3 (37., 39., 41.)) * cHashM);
}

float Noiseff (float p)
{
  vec2 t;
  float ip, fp;
  ip = floor (p);
  fp = fract (p);
  fp = fp * fp * (3. - 2. * fp);
  t = Hashv2f (ip);
  return mix (t.x, t.y, fp);
}

float Noisefv2 (vec2 p)
{
  vec2 t, ip, fp;
  ip = floor (p);  
  fp = fract (p);
  fp = fp * fp * (3. - 2. * fp);
  t = mix (Hashv2v2 (ip), Hashv2v2 (ip + vec2 (0., 1.)), fp.y);
  return mix (t.x, t.y, fp.x);
}

float Fbm1 (float p)
{
  float f, a;
  f = 0.;
  a = 1.;
  for (int j = 0; j < 5; j ++) {
    f += a * Noiseff (p);
    a *= 0.5;
    p *= 2.;
  }
  return f * (1. / 1.9375);
}

float Fbm2 (vec2 p)
{
  float f, a;
  f = 0.;
  a = 1.;
  for (int j = 0; j < 5; j ++) {
    f += a * Noisefv2 (p);
    a *= 0.5;
    p *= 2.;
  }
  return f * (1. / 1.9375);
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

